#include "SelfRotatingCamera.h"



SelfRotatingCamera::SelfRotatingCamera(Vector3 origin, Vector3 pitchYawRoll, RotationAxis rotAxis, float minRot, float maxRot, int pauseBoundsDur) : Camera(1.0f, origin, pitchYawRoll)
{
	//Set values passed in, pass some to base constructor
	_MouseRotationSpeed = 0.0f;
	_RotationAxis = rotAxis;
	_MinimumRot = minRot;
	_MaximumRot = maxRot;
	_PauseBoundsDuration = pauseBoundsDur;
	Reset();
}

SelfRotatingCamera::SelfRotatingCamera(Vector3 origin, Vector3 pitchYawRoll, float speed, RotationAxis rotAxis, float minRot, float maxRot, int pauseBoundsDur) : Camera(speed, origin, pitchYawRoll)
{
	//Set values passed in, pass some to base constructor
	_MouseRotationSpeed = 0.0f;
	_RotationAxis = rotAxis;
	_MinimumRot = minRot;
	_MaximumRot = maxRot;
	_PauseBoundsDuration = pauseBoundsDur;
	Reset();
}


SelfRotatingCamera::~SelfRotatingCamera()
{
}

void SelfRotatingCamera::Animate(float dt)
{
	if (!_IsPaused && (_Yaw > _MaximumRot || _Yaw < _MinimumRot))	//If we're not paused but we've exceeded the range of motion set
	{
		_IsPaused = true;	//We pause motion now
		_Yaw -= 2 * (_Speed) * dt;	//Prevents camera getting stuck, good cheat, unnoticable
	}

	else if (!_IsPaused)	//If we're not paused and are in the range of motion
	{
		switch (_RotationAxis)
		{
			case RotationAxis::Y:
				_Yaw += _Speed * dt;	//Change Yaw (rotation in Y)
				break;

			//This could be expanded in the future to add other axis's of rotation if needed
		}
	}

	if (_IsPaused)	//If we're paused
	{
		_TimePaused += dt;	//Increment time paused by delta time
		if (_TimePaused >= (_PauseBoundsDuration * 10))	//If we've exceeded how long we should pause for
		{
			_Speed = -_Speed;	//Negative speed to rotate in opposite direction
			_TimePaused = 0.0;	//
			_IsPaused = false;	//		Reset variables
		}
	}

	Update();
}

void SelfRotatingCamera::MoveForward(float dt)
{
	
}

void SelfRotatingCamera::MoveRight(float dt)
{

}

void SelfRotatingCamera::MoveUp(float dt)
{

}

void SelfRotatingCamera::RotateX(float dt)
{

}

void SelfRotatingCamera::RotateY(float dt)
{

}

void SelfRotatingCamera::RotateZ(float dt)
{

}

void SelfRotatingCamera::RotateFromMouse(float xOffset, float yOffset, float dt)
{
	
}